/*
 * Decompiled with CFR 0.152.
 */
package com.tom.chunkstorage.api;

import com.tom.chunkstorage.api.DataObject;
import com.tom.chunkstorage.api.DataObjectKey;
import com.tom.chunkstorage.impl.LevelChunkAccess;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2818;
import net.minecraft.class_2960;

public class ChunkStorageApi {
    public static final String CHUNK_DATA_TAG = "ChunkStorageLib-Data";
    private static Map<class_2960, DataObjectKey<?>> dataObjectKeys = new HashMap();

    public static synchronized <T extends DataObject> DataObjectKey<T> registerObjectFactory(class_2960 id, Supplier<T> factory) {
        if (id == null || factory == null) {
            throw new IllegalArgumentException("Null arguments");
        }
        DataObjectKey<T> key = new DataObjectKey<T>(id, factory);
        dataObjectKeys.put(id, key);
        return key;
    }

    public static <T extends DataObject> T getFromChunk(class_2818 chunk, DataObjectKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (chunk == null) {
            throw new IllegalArgumentException("Null chunk");
        }
        if (chunk.method_12200().field_9236) {
            throw new IllegalStateException("Chunk Data accessed from client, Data ID: " + key.id());
        }
        return ((LevelChunkAccess)chunk).csa$getStorage().get(key);
    }

    public static <T extends DataObject> T getOrCreateFromChunk(class_2818 chunk, DataObjectKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (chunk == null) {
            throw new IllegalArgumentException("Null chunk");
        }
        if (chunk.method_12200().field_9236) {
            throw new IllegalStateException("Chunk Data accessed from client, Data ID: " + key.id());
        }
        return ((LevelChunkAccess)chunk).csa$getStorage().getOrCreate(key);
    }

    public static DataObjectKey<?> getKey(class_2960 id) {
        return dataObjectKeys.get(id);
    }
}

